IF EXISTS (SELECT 1	FROM SYS.VIEWS	WHERE NAME = 'V_PDV_CAMPANHA_ADICIONAIS_FILTRO')
	DROP VIEW [DBO].[V_PDV_CAMPANHA_ADICIONAIS_FILTRO]
GO
/*
=======================================================================================
'NOME................: V_PDV_CAMPANHA_ADICIONAIS_FILTRO
'OBJETIVO............: RETORNAR CAMPOS PARA FILTRO DE PESQUISA NA FUNO(PESQ_CAMP_VENDAS_ADIC)
'TABELAS.............: PDV_CAMPANHA_ADICIONAIS
'DT CRIAO..........: 22/03/2024
'DT ULT ALTERACO....: 
'CRIADO POR..........: ADEMILSON ALVES
'ALTERADO POR........:  
'REVISADO POR........: 
'ULT ALTERACAO.......: 
'=======================================================================================
 SELECT * FROM V_PDV_CAMPANHA_ADICIONAIS_FILTRO WHERE STS_CAMPANHA=0
 SELECT * FROM PDV_CAMPANHA_ADICIONAIS WHERE DT_INICIO > GETDATE()

*/

CREATE VIEW [DBO].[V_PDV_CAMPANHA_ADICIONAIS_FILTRO]
AS
SELECT DISTINCT 
	CD_EMP,
	CD_CAMPANHA_ADIC, DS_CAMPANHA_ADIC, DT_CAD, DT_VALID, 
	CASE WHEN CONVERT(VARCHAR(20),DT_INICIO,120) > CONVERT(VARCHAR(20),GETDATE(),120) THEN
		0 ---PENDENTE
	WHEN CONVERT(VARCHAR(20),DT_INICIO,120) <= CONVERT(VARCHAR(20),GETDATE(),120) AND CONVERT(VARCHAR(20),DT_VALID,120) >= CONVERT(VARCHAR(20),GETDATE(),120) THEN
		1 --- EM VIGENCIA
	WHEN CONVERT(VARCHAR(20),DT_VALID,120) < CONVERT(VARCHAR(20),GETDATE(),120) THEN
		2  ---- FINALIZADO
	END AS STS_CAMPANHA

FROM PDV_CAMPANHA_ADICIONAIS 

WHERE CD_EMP =1

